<?php

namespace Drupal\security_login_secure\Form\Section;

use Drupal\Core\Form\FormStateInterface;
use Drupal\security_login_secure\Utilities;
use Drupal\security_login_secure\Form\WebsiteSecurityIPBlocking;
use Drupal\security_login_secure\MiniorangeWebsiteSecurityConstants;
use Drupal\user\Entity\Role;

/**
 * Form handler for Advanced blocking settings.
 */
class RoleLoginIPConfigurationForm extends WebsiteSecurityIPBlocking
{

    /**
     * {@inheritdoc}
     */
    public function build_role_login_ip_config_form(array &$form, FormStateInterface $form_state)
    {
        global $base_url;
        $disabled = TRUE;
        $info_icon_url = Utilities::get_info_icon();

        $form['role_login_markup_top'] = [
            '#type' => 'details',
            '#title' => $this->t('Allow Role Login by IP Configuration'),
            '#group' => 'information',
        ];

        $form['role_login_markup_top']['website_security_allowed_ip_range_value'] = [
            '#type' => 'textfield',
            '#title' => $this->t('Allowed IP Range <a href=":premium_url">[Premium]</a><div class="ns_tooltip"><img src=":info_icon_url" alt="info icon" height="20px" width="15px"></div><div class="ns_tooltiptext">This feature allows you to select roles and provide IP range in which user with selected role and IP address within defined IP range will be allowed to login.</div>', [':info_icon_url' => $info_icon_url, ':premium_url' => $base_url . MiniorangeWebsiteSecurityConstants::LICENSING_TAB_URL]),
            '#attributes' => array('placeholder' => 'For eg. 123.2.3.1-123.2.3.25;145.25.32.2-145.25.32.15'),
            '#description' => $this->t('<b>Note: </b>Provide dash(-) in between the IP range that you want to block and if you want to block multiple IP range then separate them using semi-colon(;).'),
            '#disabled' => $disabled,
        ];

        $mrole = Role::loadMultiple();

        $form['role_login_markup_top']['website_security_select_roles_markup'] = [
            '#markup' => $this->t('<br><b>What roles do you want to allow login within specified IP range? <a href=":premium_url">[Premium]</a></b>', [':premium_url' => $base_url . MiniorangeWebsiteSecurityConstants::LICENSING_TAB_URL])
        ];

        foreach ($mrole as $key => $value) {
            $form['role_login_markup_top']['website_security_allowed_role_' . $key] = [
                '#type' => 'checkbox',
                '#title' => $value->label(),
                '#disabled' => $disabled,
            ];
        }
    }
}
