<?php

/**
 * @file
 * Contains \Drupal\security_login_secure\Form\WebsiteSecurityCustomerSetup.
 */

namespace Drupal\security_login_secure\Form;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Form\FormBase;
use Drupal\security_login_secure\Utilities;
use Drupal\security_login_secure\MiniorangeWebsiteSecurityVerificationCustomer;
use Drupal\security_login_secure\MiniorangeWebsiteSecurityConstants;
use Symfony\Component\HttpFoundation;
use Symfony\Component\HttpFoundation\RedirectResponse;

class WebsiteSecurityCustomerSetup extends FormBase
{

    public function getFormId()
    {
        return 'mo_website_security_customer_setup';
    }

    public function buildForm(array $form, FormStateInterface $form_state)
    {

        $form['markup_library'] = array(
            '#attached' => array(
                'library' => array(
                    "security_login_secure/security_login_secure.admin",
                )
            )
        );

        global $base_url;

        $current_status = $this->config('security_login_secure.settings')->get('website_security_status');

        if ($current_status == 'PLUGIN_CONFIGURATION') {

            //Utilities::visual_tour_start($form, $form_state);

            $form['markup_top'] = array(
                '#markup' => '<div class="ns_table_layout_1"><div class="ns_table_layout ns_container">
                                  <div class="ns_welcome_message">Thank you for registering with miniOrange</div><br><br>
                                  <h4>Your Profile: </h4>'
            );

            $header = array(
                'email' => array('data' => $this->t('Customer Email')),
                'customerid' => array('data' => $this->t('Customer ID')),
                'token' => array('data' => $this->t('Token Key')),
                'apikey' => array('data' => $this->t('API Key')),
            );

            $options = [];
            $options[0] = array(
                'email' => $this->config('security_login_secure.settings')->get('website_security_customer_admin_email'),
                'customerid' => $this->config('security_login_secure.settings')->get('website_security_customer_id'),
                'token' => $this->config('security_login_secure.settings')->get('website_security_customer_admin_token'),
                'apikey' => $this->config('security_login_secure.settings')->get('website_security_customer_api_key'),
            );

            $form['fieldset']['customerinfo'] = array(
                '#theme' => 'table',
                '#header' => $header,
                '#rows' => $options,
                '#suffix' => '<br><br><br><br><br><br><h4>Remove Account:</h4>'
            );

            $form['Premium_feature_Note'] = array(
                '#markup' => '<div class="ns_highlight_background_note"><b>Note:</b> This feature is available in <a href="' . $base_url . MiniorangeWebsiteSecurityConstants::LICENSING_TAB_URL . '">[Premium]</a> version of the module</div>',
            );

            $form['website_security_customer_Remove_Account'] = array(
                '#type' => 'submit',
                '#value' => $this->t('Remove Account'),
                '#disabled' => TRUE,
                '#suffix' => '<br><br><hr></div>',
                '#prefix' => '<p>This section will help you to remove your current logged in account without losing your current configurations.</p>'
            );

            $form['main_layout_div_end_1'] = array(
                '#markup' => '<div>',
            );

            return $form;
        }

        $form['markup_top'] = array(
            '#markup' => '<h2>Login with miniOrange</h2><hr>',
            '#prefix' => '<div class="ns_table_layout_1"><div id="Register_Section" class="ns_table_layout ns_container">'
        );

        $form['website_security_customer_email'] = array(
            '#type' => 'textfield',
            '#title' => $this->t('Email'),
            '#required' => True
        );

        $form['website_security_customer_password'] = array(
            '#type' => 'password',
            '#title' => $this->t('Password'),
            '#required' => True,
            '#attributes' => array(
                'style' => 'width:80%'
            ),
        );

        $form['login_submit'] = array(
            '#type' => 'submit',
            '#button_type' => 'primary',
            '#value' => $this->t('Login')
        );

        $form['main_layout_div_end_1'] = array(
            '#markup' => '</div>',
        );

        return $form;
    }

    public function submitForm(array &$form, FormStateInterface $form_state)
    {

        $db_var = \Drupal::configFactory()->getEditable('security_login_secure.settings');
        $current_status = $db_var->get('website_security_status');
        $phone = NULL;

        $username = trim($form['website_security_customer_email']['#value']);
        $password = trim($form['website_security_customer_password']['#value']);

        if (empty($username) || empty($password)) {
            \Drupal::messenger()->addMessage($this->t('The <b><u>Email </u></b> and <b><u>Password</u></b> fields are mandatory.'), 'error');
            return;
        }

        if (!\Drupal::service('email.validator')->isValid($username)) {
            \Drupal::messenger()->addMessage($this->t('The email address <i>:username</i> is not valid.', ['username' => $username]), 'error');
            return;
        }

        $customer_config = new MiniorangeWebsiteSecurityVerificationCustomer($username, $phone, $password, NULL);
        $check_customer_response = json_decode($customer_config->checkCustomer());

        if (!is_object($check_customer_response) || !isset($check_customer_response->status) || empty($check_customer_response->status)) {
            \Drupal::messenger()->addMessage($this->t('Error: Something went wrong while processing your request. Reference No.:D8SSE|0001'));
            return;
        } elseif ($check_customer_response->status == 'TRANSACTION_LIMIT_EXCEEDED') {
            \Drupal::messenger()->addMessage($this->t('An error has been occured. Please try after some time.'), 'error');
        } elseif ($check_customer_response->status == 'CURL_ERROR') {
            \Drupal::messenger()->addMessage($this->t('cURL is not enabled. Please enable cURL'), 'error');
        } else {
            $customer_keys_response = json_decode($customer_config->getCustomerKeys());
            if (json_last_error() == JSON_ERROR_NONE) {
                $current_status = 'PLUGIN_CONFIGURATION';

                $db_var->set('website_security_customer_id', $customer_keys_response->id)
                    ->set('website_security_customer_admin_token', $customer_keys_response->token)
                    ->set('website_security_customer_admin_email', $username)
                    ->set('website_security_customer_admin_phone', $phone)
                    ->set('website_security_customer_api_key', $customer_keys_response->apiKey)
                    ->set('website_security_status', $current_status)
                    ->save();

                \Drupal::messenger()->addMessage($this->t('Successfully retrieved your account.'), 'status');
            } else {
                \Drupal::messenger()->addMessage($this->t('Invalid credentials'), 'error');
            }
        }
    }

    public function website_security_back(&$form, $form_state)
    {
        $current_status = 'LOGIN';
        $db_var = \Drupal::configFactory()->getEditable('security_login_secure.settings');
        $db_var->set('website_security_status', $current_status)->save();

        $db_var->clear('website_security_customer_admin_email')
            ->clear('website_security_customer_admin_phone')
            ->clear('website_security_tx_id')
            ->save();

        \Drupal::messenger()->addMessage($this->t('Register/Login with your miniOrange Account'), 'status');
    }
}
