<?php

namespace Drupal\security_login_secure\Repository;

use Drupal\Core\Database\Connection;

class MiniorangeReportsRepository
{
    /**
     * The database connection.
     *
     * @var Connection
     */
    protected $connection;

    /**
     * Construct a repository object.
     *
     * @param Connection $connection
     *   The database connection.
     */
    public function __construct(Connection $connection)
    {
        $this->connection = $connection;
    }

    /**
     * To log in reports table
     * 
     * @param string ip_address
     * @param string username
     * @param string status
     */
    public function mo_website_security_add_reports_entry($ip_addresses, $username, $status)
    {
        $ip_addresses = explode(';', $ip_addresses);
        foreach ($ip_addresses as $ip_address) {
            if (!empty($ip_address)) {
                $this->connection->insert('miniorange_website_security_reports')
                    ->fields([
                        'ip_address' => $ip_address,
                        'uname' => $username,
                        'status' => $status,
                        'timestamp' => \Drupal::time()->getRequestTime(),
                    ])
                    ->execute();
            }
        }
    }

    /**
     * Reports filter callback function to filter reports data
     * 
     * @param string order - order to display the data
     */
    public function mo_website_security_return_search_values($order = 'DESC')
    {
        $db_var = \Drupal::config('security_login_secure.settings');
        $ip_value = $db_var->get('website_security_ip_value');
        $username_value = $db_var->get('website_security_username_value');
        $status_value = $db_var->get('website_security_status_value');

        if (isset($ip_value) && !empty($ip_value) && isset($username_value) && !empty($username_value) && filter_var($ip_value, FILTER_VALIDATE_IP)) {
            if ($status_value != 'All') {
                $reports = $this->connection->select('miniorange_website_security_reports', 'ns_ip')
                    ->fields('ns_ip')
                    ->condition('ip_address', $ip_value, '=')
                    ->condition('uname', $username_value, '=')
                    ->condition('status', $status_value, '=')
                    ->orderBy('timestamp', $order)
                    ->execute()
                    ->fetchAll();
            } else {
                $reports = $this->connection->select('miniorange_website_security_reports', 'ns_ip')
                    ->fields('ns_ip')
                    ->condition('ip_address', $ip_value, '=')
                    ->condition('uname', $username_value, '=')
                    ->orderBy('timestamp', $order)
                    ->execute()
                    ->fetchAll();
            }
        } elseif (isset($ip_value) && !empty($ip_value) && filter_var($ip_value, FILTER_VALIDATE_IP)) {
            if ($status_value != 'All') {
                $reports = $this->connection->select('miniorange_website_security_reports', 'ns_ip')
                    ->fields('ns_ip')
                    ->condition('ip_address', $ip_value, '=')
                    ->condition('status', $status_value, '=')
                    ->orderBy('timestamp', $order)
                    ->execute()
                    ->fetchAll();
            } else {
                $reports = $this->connection->select('miniorange_website_security_reports', 'ns_ip')
                    ->fields('ns_ip')
                    ->condition('ip_address', $ip_value, '=')
                    ->orderBy('timestamp', $order)
                    ->execute()
                    ->fetchAll();
            }
        } elseif (isset($username_value) && !empty($username_value)) {
            if ($status_value != 'All') {
                $reports = $this->connection->select('miniorange_website_security_reports', 'ns_ip')
                    ->fields('ns_ip')
                    ->condition('uname', $username_value, '=')
                    ->condition('status', $status_value, '=')
                    ->orderBy('timestamp', $order)
                    ->execute()
                    ->fetchAll();
            } else {
                $reports = $this->connection->select('miniorange_website_security_reports', 'ns_ip')
                    ->fields('ns_ip')
                    ->condition('uname', $username_value, '=')
                    ->orderBy('timestamp', $order)
                    ->execute()
                    ->fetchAll();
            }
        } else {
            if (isset($status_value) && !empty($status_value) && $status_value != 'All') {
                $reports = $this->connection->select('miniorange_website_security_reports', 'ns_ip')
                    ->fields('ns_ip')
                    ->condition('status', $status_value, '=')
                    ->orderBy('timestamp', $order)
                    ->execute()
                    ->fetchAll();
            } else {
                $reports = $this->connection->select('miniorange_website_security_reports', 'ns_ip')
                    ->fields('ns_ip')
                    ->orderBy('timestamp', $order)
                    ->execute()
                    ->fetchAll();
            }
        }

        return $reports;
    }
}
