<?php

namespace Drupal\security_login_secure\Service;

class MiniorangeIPSecurityManager
{
    public function initiateIPSecurityChecks($ip_address, $username, $authenticate, $db_var, $form_state)
    {
        $miniorangeIPSecurityRepository = \Drupal::service('security_login_secure.ip_security_repository');
        $allowed_attempts_ip = $db_var->get('website_security_ip_allowed_attempts');
        $attack_detection = $db_var->get('website_security_ip_attack_detection');
        // This is to clear failed login attempts stored in Drupal flood table so that Drupal default behaviour of blocking IP does not dominate
        $miniorangeIPSecurityRepository->mo_website_security_clear_flood_table_events_ip();
        // If authentication is failed then we have to take actions accordingly
        if ($authenticate == false) {
            $track_time = $db_var->get('website_security_ip_track_time');
            $track_time = !empty($track_time) ? $track_time *= 3600 : 0;
            $timestamp = $miniorangeIPSecurityRepository->mo_website_security_get_timestamp_ip($ip_address);
            $time_diff_ip = \Drupal::time()->getRequestTime() - $timestamp;

            // We have to clear all the failed login attempts of that IP if tracking time is completed. After that those failed login attempts will never be counted
            if ($time_diff_ip > $track_time && $track_time > 0)
                $miniorangeIPSecurityRepository->mo_website_security_clear_events_ips($ip_address, $username, false);

            $ip_attempts = $miniorangeIPSecurityRepository->mo_website_security_get_ip_attempts($ip_address);

            // Add failed IP attempt in that client IP entry
            if ($allowed_attempts_ip > 0) {
                $ip_attempts += 1;
                $miniorangeIPSecurityRepository->mo_website_security_add_ip($username, $ip_address, $ip_attempts);
            }

            // If no of failed IP login attempts have reached the limit of allowed attempts then block that IP from login
            if ($ip_attempts >= $allowed_attempts_ip && $allowed_attempts_ip > 0) {

                $miniorangeIPSecurityRepository->mo_website_security_block_ip($username, $ip_address, 'blocked',);
                $form_state->clearErrors();
                $form_state->setErrorByName('test', t('Your IP is blocked. You have reached the maximum failed login limit of :allowed_attempts_ip Please contact your administrator.', [':allowed_attempts_ip' => $allowed_attempts_ip]));

                // This is to send email notification on blocking
                if (!isset($_SESSION['ip_block']))
                    mo_website_security_send_email_notification($username, $ip_address, 'ip_block');
            } elseif ($ip_attempts >= $attack_detection && $attack_detection > 0 && !isset($_SESSION['ip_attack'])) {
                //  If no of failed IP login attempts have reached the limit of attack detection attempts then send an email notification
                mo_website_security_send_email_notification($username, $ip_address, 'ip_attack');
            }
        }
    }
}
