<?php

namespace Drupal\security_login_secure\Service;

class MiniorangeUserSecurityManager
{
    public function initiateUserSecurityChecks($ip_address, $account, $username, $authenticate, $db_var, $form_state)
    {
        $miniorangeUserSecurityRepository = \Drupal::service('security_login_secure.user_security_repository');

        // This is to clear failed login attempts stored in Drupal flood table so that Drupal default behaviour of blocking user does not dominate
        $miniorangeUserSecurityRepository->mo_website_security_clear_flood_table_events_user();
        // The users that were blocked due to failed login attempts will be unblocked in this function if there blocking time has been expired.
        $clear_error = $miniorangeUserSecurityRepository->mo_website_security_clear_events_users($ip_address, $username, $account);
        $allowed_attempts_user = $db_var->get('website_security_user_allowed_attempts');
        $track_time = $db_var->get('website_security_user_track_time');

        // If the user is unblocked then we have to clear all errors that were generated by default Drupal validations before our validation function was called. The error was that user is already blocked(bcz right now we have unblocked that user in our validation). If we do not clear that error then it will show that user is blocked even if we have unblocked that user bcz it was stored in errors already.
        if ($clear_error == 1) {
            $form_state->clearErrors();
        }
        // If authentication is failed then we have to take actions accordingly
        if ($authenticate == false && !empty($account) && $account->status->value == 1) {
            $track_time = !empty($track_time) ? $track_time *= 3600 : 0;

            $timestamp = $miniorangeUserSecurityRepository->mo_website_security_get_timestamp_user($username);
            $time_diff_user = \Drupal::time()->getRequestTime() - $timestamp;

            // We have to clear all the failed login attempts of that user if tracking time is completed. After that those failed login attempts will never be counted
            if ($time_diff_user > $track_time && $track_time > 0)
                $miniorangeUserSecurityRepository->mo_website_security_clear_events_users($ip_address, $username, $account, false);

            $user_attempts = $miniorangeUserSecurityRepository->mo_website_security_get_user_attempts($username);

            $attack_detection = $db_var->get('website_security_user_attack_detection');

            // Add failed user attempt
            if ($allowed_attempts_user > 0) {
                $user_attempts += 1;
                $miniorangeUserSecurityRepository->mo_website_security_add_user($username, $ip_address, $user_attempts);
            }

            // If no of failed user login attempts have reached the limit of allowed attempts then block that user from login
            if ($user_attempts >= $allowed_attempts_user && $allowed_attempts_user > 0) {

                $miniorangeUserSecurityRepository->mo_website_security_block_user($ip_address, $username);
                $form_state->clearErrors();
                $form_state->setErrorByName('test', t('Sorry, there have been ' . $allowed_attempts_user . ' failed login attempts for this account. It is temporarily blocked.'));

                // This is to send email notification on blocking
                if (!isset($_SESSION['user_block']))
                    mo_website_security_send_email_notification($username, $ip_address, 'user_block');

                return;
            } elseif ($user_attempts >= $attack_detection && $attack_detection > 0 && !isset($_SESSION['user_attack'])) {
                //  If no of failed user login attempts have reached the limit of attack detection attempts then send an email notification
                mo_website_security_send_email_notification($username, $ip_address, 'user_attack');
            }

            $show_remaining_attempts = $db_var->get('website_security_show_remaining_attempts');
            $remaining_attempts = !empty($allowed_attempts_user) ? $allowed_attempts_user - $user_attempts : 0;

            // If show remaining attempts is enabled then show them to user
            if ($show_remaining_attempts == 1) {
                $form_state->clearErrors();
                $form_state->setErrorByName('test', t('Invalid Credentials. You have ' . $remaining_attempts . ' attempts remaining.'));
            }
        } elseif ($miniorangeUserSecurityRepository->mo_website_security_user_blocked_invalid_attempt($username)) {
            // If user authentication is successful but that user is blocked due to failed login attempts then show this error message to that user.
            $form_state->clearErrors();
            $form_state->setErrorByName('test', t('Sorry, there have been ' . $allowed_attempts_user . ' failed login attempts for this account. It is temporarily blocked.'));
        }
    }
}
