(function ($, Drupal) {
  Drupal.behaviors.active_view_mode = {
    attach: function (context, settings) {
      var viewModesElements = document.querySelectorAll(
        ".field--name-field-seeds-view-mode .form-type--radio"
      );

      viewModesElements.forEach(function (viewModeElement) {
        var lastChild = viewModeElement.lastElementChild;
        lastChild.addEventListener("click", function () {
          // Remove 'active' class from all lastChild elements
          viewModesElements.forEach(function (viewModeElement) {
            viewModeElement.lastElementChild.classList.remove("active");
          });

          // Add 'active' class to the clicked lastChild
          lastChild.classList.add("active");
        });
      });
    },
  };
})(jQuery, Drupal);
