<?php

namespace Drupal\seeds_layouts_classes_extractor\Plugin\ClassesExtractor;

use Drupal\classes_extractor\ClassesExtractorBase;
use Drupal\classes_extractor\ClassesExtractorManager;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides a Seeds Layout class Extractor plugin.
 *
 * @ClassesExtractor(
 *   id = "seeds_layout_class_extractor",
 *   label = @Translation("Seeds Layout class Extractor")
 * )
 */
class SeedsLayoutClassExtractor extends ClassesExtractorBase implements ContainerFactoryPluginInterface {

  /**
   * The entity type manager service.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  /**
   * The entity type manager service.
   *
   * @var \Drupal\classes_extractor\ClassesExtractorManager
   */
  protected $classExtractorManager;

  /**
   * Constructs an EntityDisplayClassesExtractor object.
   *
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entity_type_manager
   *   The entity type manager service.
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $class_extractor_manager
   *   The entity type manager service.
   */
  public function __construct(EntityTypeManagerInterface $entity_type_manager, ClassesExtractorManager $class_extractor_manager) {
    $this->entityTypeManager = $entity_type_manager;
    $this->classExtractorManager = $class_extractor_manager;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $container->get('entity_type.manager'),
      $container->get('classes_extractor.manager')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getClasses(): array {
    $classes = [];
    // Extract classes from Seeds Layouts module.
    $seedsLayoutsConfig = \Drupal::config('seeds_layouts.config');
    $classes[] = $this->classExtractorManager->recursiveGetClasses($seedsLayoutsConfig->getRawData(), $classes);
    return $classes;
  }

}
