<?php

namespace Drupal\seeds_layouts\Plugin\LayoutBuilderRestriction;

use Drupal\Core\Config\Entity\ThirdPartySettingsInterface;
use Drupal\Core\Session\AccountProxyInterface;
use Drupal\layout_builder_restrictions\Plugin\LayoutBuilderRestrictionBase;
use Drupal\layout_builder\OverridesSectionStorageInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Controls behavior of the by region plugin.
 *
 * @LayoutBuilderRestriction(
 *   id = "seeds_restrict_block_choose",
 *   title = @Translation("Restrict Block Choose"),
 *   description = @Translation("Restrict Block Choose.")
 * )
 */
class SeedsRestrictBlockchoose extends LayoutBuilderRestrictionBase {

  /**
   * Session account proxy interface.
   *
   * @var Drupal\Core\Session\AccountProxyInterface
   */
  protected $currentUser;

  /**
   * Constructs a Drupal\Component\Plugin\PluginBase object.
   *
   * @param array $configuration
   *   A configuration array containing information about the plugin instance.
   * @param string $plugin_id
   *   The plugin_id for the plugin instance.
   * @param mixed $plugin_definition
   *   The plugin implementation definition.
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition, AccountProxyInterface $current_user) {
    $this->configuration = $configuration;
    $this->pluginId = $plugin_id;
    $this->pluginDefinition = $plugin_definition;
    $this->currentUser = $current_user;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('current_user')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function alterBlockDefinitions(array $definitions, array $context) {
    if (!isset($context['delta'])) {
      return $definitions;
    }

    if (isset($context['section_storage'])) {
      $default = $context['section_storage'] instanceof OverridesSectionStorageInterface ? $context['section_storage']->getDefaultSectionStorage() : $context['section_storage'];
      if ($default instanceof ThirdPartySettingsInterface) {

        foreach ($definitions as $delta => $definition) {
          $original_delta = $delta;
          if (!$this->currentUser->hasPermission("access all blocks layouts")) {
            // Show only the block content was created.
            if (!\preg_match('/^block_content:/', $original_delta) && !\preg_match('/^webform_block/', $original_delta)) {
              unset($definitions[$original_delta]);
            }
          }
        }
      }
    }
    return $definitions;
  }

}
