/**
 * @file
 */

(function ($, Drupal, drupalSettings) {
  Drupal.behaviors.global = {
    attach: function (context, settings) {
      // When Click on the checkbox add class to the sibling label selectedStyle
      $(".fieldset-wrapper input[type=radio]").on("click", function () {
        $(this)
          .parent()
          .parent()
          .find("input[type=radio]")
          .each(function () {
            $(this).parent().find("label").removeClass("selectedStyle");
          });
        $(this).parent().find("label").addClass("selectedStyle");
      });

      $("#seeds-container li a").each(function () {
        $(this).on("click", function () {
          $("#seeds-container li a").removeClass("active");
          $(this).toggleClass("active");
          var href = $(this).attr("data-target");
          if (href && $("#seeds-body").length) {
            $(".seeds-body-item").removeClass("active");
            $(".seeds-body--" + href).addClass("active");
          }
        });
      });
    },
  };
  Drupal.behaviors.add_section = {
    attach: function (context, settings) {
      // Select all elements with the layout-builder__section class
      var sectionElements = document.querySelectorAll(
        ".layout-builder__section"
      );
      // Add event listeners for each section element
      sectionElements.forEach(function (sectionElement) {
        sectionElement.addEventListener("mouseenter", function () {
          // Get the previous and next sibling elements
          var prevSibling = sectionElement.previousElementSibling;
          var nextSibling = sectionElement.nextElementSibling;

          // Add the 'highlight' class to the previous sibling if it has the right class
          if (
            prevSibling &&
            prevSibling.classList.contains("layout-builder__add-section")
          ) {
            prevSibling.classList.add("highlight");
          }

          // Add the 'highlight' class to the next sibling if it has the right class
          if (
            nextSibling &&
            nextSibling.classList.contains("layout-builder__add-section")
          ) {
            nextSibling.classList.add("highlight");
          }
        });

        sectionElement.addEventListener("mouseleave", function () {
          // Get the previous and next sibling elements
          var prevSibling = sectionElement.previousElementSibling;
          var nextSibling = sectionElement.nextElementSibling;

          // Remove the 'highlight' class from the previous sibling if it has the right class
          if (
            prevSibling &&
            prevSibling.classList.contains("layout-builder__add-section")
          ) {
            prevSibling.classList.remove("highlight");
          }

          // Remove the 'highlight' class from the next sibling if it has the right class
          if (
            nextSibling &&
            nextSibling.classList.contains("layout-builder__add-section")
          ) {
            nextSibling.classList.remove("highlight");
          }
        });
      });

      document.querySelectorAll("#layout-builder-modal").forEach((child) => {
        const parent = child.parentElement;
        if (parent) {
          parent.classList.add("layout-builder-modal-dialog");
        }
      });
    },
  };

  Drupal.behaviors.active_view_mode = {
    attach: function (context, settings) {
      var viewModesElements = document.querySelectorAll(
        ".field--name-field-seeds-view-mode .seeds--lb-form-item"
      );

      viewModesElements.forEach(function (viewModeElement) {
        var lastChild = viewModeElement.lastElementChild;
        lastChild.addEventListener("click", function () {
          // Remove 'active' class from all lastChild elements
          viewModesElements.forEach(function (viewModeElement) {
            viewModeElement.lastElementChild.classList.remove("active");
          });

          // Add 'active' class to the clicked lastChild
          lastChild.classList.add("active");
        });
      });
    },
  };
})(jQuery, Drupal, drupalSettings);
