<?php

namespace Drupal\seeds_layouts\EventSubscriber;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\Event\ViewEvent;
use Symfony\Component\HttpKernel\KernelEvents;

/**
 * Class LayoutBuilderBrowserEventSubscriber.
 *
 * Add layout builder css class layout-builder-browser.
 */
class LayoutBuilderBrowserEventSubscriber implements EventSubscriberInterface {

  public const KERNEL_WEIGHT = 50;

  /**
   * Add layout-builder-browser class layout_builder.choose_block build block.
   */
  public function onView(ViewEvent $event): void {
    $request = $event->getRequest();
    $route = $request->attributes->get('_route');
    $build = $event->getControllerResult();

    if ($route == 'layout_builder.choose_block') {
      if (\is_array($build) && isset($build['add_block'])) {
        $build['block_categories']['#attributes']['class'][] = 'seeds-layouts-lb-block-categories';
        $build['filter']['#attributes']['class'][] = 'seeds-layouts-lb-filter';
        $build['add_block']['#attributes']['class'][] = 'seeds-layouts-lb-add-block';

        $event->setControllerResult($build);
      }
    }
    if ($route == "layout_builder.choose_inline_block") {
      if (\is_array($build) && isset($build["back_button"])) {
        $build['links']['#attributes']['class'][] = 'seeds-layouts-lb-inline-block';
        $build['back_button']['#attributes']['class'][] = 'seeds-layouts-lb-back-button';
        $event->setControllerResult($build);
      }
    }
    if ($route == "layout_builder.choose_section") {
      if (\is_array($build) && isset($build["layouts"])) {
        $build['layouts']['#attributes']['class'][] = 'seeds-layouts-lb-sections';
        $event->setControllerResult($build);
      }
    }
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    $events = [];
    $events[KernelEvents::VIEW][] = ['onView', static::KERNEL_WEIGHT];
    return $events;
  }

}
