const chokidar = require("chokidar");
const { exec } = require("child_process");
const path = require("path");

// Array of file pairs to watch and compile
const filesToWatch = [
  {
    inputFile: "./assets/style/button.pcss.css",
    outputFile: "./assets/css/button.css",
  },
  {
    inputFile: "./assets/style/dialog.pcss.css",
    outputFile: "./assets/css/dialog.css",
  },
  {
    inputFile: "./assets/style/fieldset.pcss.css",
    outputFile: "./assets/css/fieldset.css",
  },
  {
    inputFile: "./assets/style/form--checkbox.pcss.css",
    outputFile: "./assets/css/form--checkbox.css",
  },
  {
    inputFile: "./assets/style/form--select.pcss.css",
    outputFile: "./assets/css/form--select.css",
  },
  {
    inputFile: "./assets/style/form--text.pcss.css",
    outputFile: "./assets/css/form--text.css",
  },
  {
    inputFile: "./assets/style/layout-settings.pcss.css",
    outputFile: "./assets/css/layout-settings.css",
  },
  {
    inputFile: "./assets/style/media-library.pcss.css",
    outputFile: "./assets/css/media-library.css",
  },
  {
    inputFile: "./assets/style/module-config.pcss.css",
    outputFile: "./assets/css/module-config.css",
  },
  {
    inputFile: "./assets/style/parallax.pcss.css",
    outputFile: "./assets/css/parallax.css",
  },
  {
    inputFile: "./assets/style/views-exposed-form.pcss.css",
    outputFile: "./assets/css/views-exposed-form.css",
  },
  {
    inputFile: "./assets/style/contextual.pcss.css",
    outputFile: "./assets/css/contextual.css",
  },
  {
    inputFile: "./assets/style/description-tooltip.pcss.css",
    outputFile: "./assets/css/description-tooltip.css",
  },
  // Add more file pairs as needed
];

// PostCSS CLI command
const postcssCommand = (inputFile, outputFile) =>
  `npx postcss ${inputFile} -o ${outputFile}`;

function compile(filePath) {
  const normalizedFilePath = path.normalize(filePath);
  const filePair = filesToWatch.find(
    ({ inputFile }) => path.normalize(inputFile) === normalizedFilePath
  );

  if (!filePair) {
    console.error(`No output file specified for ${normalizedFilePath}`);
    return;
  }

  exec(
    postcssCommand(filePair.inputFile, filePair.outputFile),
    (err, stdout, stderr) => {
      if (err) {
        console.error(`Error compiling ${filePair.inputFile}:`, stderr);
      } else {
        console.log(`Compiled ${filePair.inputFile} to ${filePair.outputFile}`);
      }
    }
  );
}

function buildAll() {
  filesToWatch.forEach(({ inputFile, outputFile }) => {
    exec(postcssCommand(inputFile, outputFile), (err, stdout, stderr) => {
      if (err) {
        console.error(`Error compiling ${inputFile}:`, stderr);
      } else {
        console.log(`Compiled ${inputFile} to ${outputFile}`);
      }
    });
  });
}

function watchFiles() {
  filesToWatch.forEach(({ inputFile }) => {
    const watcher = chokidar.watch(inputFile, {
      ignored: /(^|[\/\\])\../, // ignore dotfiles
      persistent: true,
    });

    watcher
      .on("add", compile)
      .on("change", compile)
      .on("unlink", (path) => console.log(`File ${path} has been removed`));
  });

  console.log(`Watching for file changes...`);
}

// Determine whether to watch files or build all
const args = process.argv.slice(2);
if (args.includes("build")) {
  buildAll();
} else {
  watchFiles();
}
