/**
 * @file
 * Customization of messages.
 */

((Drupal, once) => {
  // Ensure Drupal.seeds_ui is initialized
  Drupal.seeds_ui = Drupal.seeds_ui || {};

  /**
   * Adds a close button to the message.
   *
   * @param {HTMLElement} message
   *   The message element.
   */
  const closeMessage = (message) => {
    const closeBtn = message.querySelector(".close_button_toast");
    if (closeBtn) {
      closeBtn.addEventListener("click", () => {
        message.classList.add("hidden");
      });
    }
  };

  /**
   * Hides the message container after a delay.
   */
  const hideMessageContainer = () => {
    const messageContainer = document.querySelector(".messages-list");
    if (messageContainer) {
      setTimeout(() => {
        messageContainer.classList.add("hidden");
      }, 5000);
    }
  };

  /**
   * Get messages from context.
   *
   * @type {Drupal~behavior}
   *
   * @prop {Drupal~behaviorAttach} attach
   *   Attaches the close button behavior for messages.
   */
  Drupal.behaviors.messages = {
    attach(context) {
      // Hide the message container after a delay
      hideMessageContainer();

      // Attach close button functionality to messages
      once("messages", '[data-drupal-selector="messages"]', context).forEach(
        (message) => closeMessage(message)
      );
    },
  };

  // Expose the closeMessage function
  Drupal.seeds_ui.closeMessage = closeMessage;
})(Drupal, once);
