import { defineConfig } from "vite";
import path from "path";

export default defineConfig({
  root: "./js",
  base: "/themes/contrib/seeds_ui/",
  build: {
    outDir: "../dist",
    emptyOutDir: false,
    rollupOptions: {
      input: {
        main: path.resolve(__dirname, "js/alpinejs.js"),
      },
      output: {
        entryFileNames: "js/alpine.js",
        assetFileNames: "[name][extname]",
      },
    },
  },
  server: {
    host: "0.0.0.0", // Allow access from network
    port: 3000,
    strictPort: true,
  },
});
