(function (Drupal) {
  Drupal.behaviors.fileSearch = {
    attach: function (context) {
      document
        .getElementById("fileSearch")
        .addEventListener("keyup", function () {
          let filter = this.value.toLowerCase();
          let files = document.querySelectorAll(".file-item");
          console.log(files);

          files.forEach((file) => {
            let fileName = file.getAttribute("data-name").toLowerCase();
            if (fileName.includes(filter)) {
              file.style.display = "flex"; // Show matching files
            } else {
              file.style.display = "none"; // Hide non-matching files
            }
          });
        });
    },
  };
})(Drupal);
