(function (Drupal) {
  Drupal.behaviors.swiperBehaviorCarousel = {
    attach: function (context) {
      document.querySelectorAll(".swiper-carousel").forEach((swiperElement) => {
        const fieldName = swiperElement.getAttribute("data-field-name");
        if (!swiperElement) {
          console.warn("Swiper container not found for field:", fieldName);
          return;
        }

        console.log("Initializing Swiper for field:", fieldName);

        new Swiper(swiperElement, {
          slidesPerView: 3,
          spaceBetween: 30,
          loop: true,
          pagination: {
            el: swiperElement.querySelector(".swiper-pagination"),
            clickable: true,
          },
          navigation: {
            nextEl: swiperElement.querySelector(".swiper-button-next"),
            prevEl: swiperElement.querySelector(".swiper-button-prev"),
          },
          autoplay: {
            delay: 5000,
            disableOnInteraction: false,
          },
        });
      });
    },
  };
})(Drupal);
