/**
 * Seeds Widgets Statistics Functionality
 * Vanilla JavaScript implementation for statistics counter functionality
 */

(function (Drupal, once) {
    Drupal.behaviors.statisticBehavior = {
      attach: function (context) {
        once("statisticBehavior", ".statistic", context).forEach((stat) => {
          const el = stat.querySelector(".statistic-value");
          const startValue = parseInt(stat.dataset.start, 10) || 0;
          const target = parseInt(stat.dataset.number, 10) || 0;
          const duration = parseInt(stat.dataset.duration, 10) || 2000;
          let startTime = null;
          let isVisible = false;
  
          const animate = (timestamp) => {
            if (!startTime) startTime = timestamp;
            const progress = timestamp - startTime;
            const percentage = Math.min(progress / duration, 1);
            const value = Math.floor(percentage * target);
            el.textContent = value.toLocaleString();
  
            if (progress < duration) {
              requestAnimationFrame(animate);
            }
          };
  
          // Intersection Observer for visibility detection
          const observer = new IntersectionObserver(
            (entries) => {
              entries.forEach((entry) => {
                if (entry.isIntersecting && !isVisible) {
                  isVisible = true;
                  startTime = null;
                  requestAnimationFrame(animate);
                } else if (!entry.isIntersecting) {
                  isVisible = false;
                  el.textContent = startValue.toLocaleString();
                }
              });
            },
            { threshold: 1.0 }
          );
  
          observer.observe(stat);
        });
      },
    };
  })(Drupal, once);
  