/**
 * Seeds Widgets Modal Functionality
 * Vanilla JavaScript implementation for modal functionality
 */

(function (Drupal, once) {
    Drupal.behaviors.modalBehavior = {
      attach: function (context) {
        const triggers = document.querySelectorAll('[data-dialog-trigger]')
        const dialogs = document.querySelectorAll('dialog')
      
        triggers.forEach(trigger => {
          trigger.addEventListener('click', e => {
            const dialog = document.querySelector(
              'dialog.' + trigger.getAttribute('data-dialog-trigger'),
            )
            console.log(dialog)
            if (dialog && dialog instanceof HTMLDialogElement) {
              dialog.showModal()
            }
          })
        })
        dialogs.forEach(dialog => {
          dialog.addEventListener('click', e => {
            if (e.target === dialog) {
              dialog.close()
            }
          })
          const closeButton = dialog.querySelector('.seeds-ui-modal-close')
          closeButton?.addEventListener('click', e => {
            dialog.close()
          })
        })
    
      },  
    };
  })(Drupal, once);