(function (Drupal) {
  Drupal.behaviors.swiperBehaviorSwiper = {
    attach: function (context) {
      document.querySelectorAll(".seeds-ui-swiper", context).forEach((swiperElement) => {
        const fieldName = swiperElement.getAttribute("data-field-name");
        if (!swiperElement) {
          console.warn("Swiper container not found for field:", fieldName);
          return;
        }

        let swiperOptions = {};
        try {
          const optionsString = swiperElement.getAttribute("data-swiper-options");
          if (optionsString) {
            swiperOptions = JSON.parse(optionsString);
          }
        } catch (error) {
          console.warn("Failed to parse swiper options:", error);
        }

        // Attach real DOM elements for navigation & pagination
        if (swiperOptions.pagination?.enabled) {
          swiperOptions.pagination.el = swiperElement.querySelector(".swiper-pagination");
        }
        if (swiperOptions.navigation?.enabled) {
          swiperOptions.navigation.nextEl = swiperElement.querySelector(".swiper-button-next");
          swiperOptions.navigation.prevEl = swiperElement.querySelector(".swiper-button-prev");
        }

        // Optional: remove custom non-Swiper keys
        const {
          enabled, source, label, id, description,
          ...cleanedOptions
        } = swiperOptions;

        new Swiper(swiperElement, cleanedOptions);
      });
    },
  };
})(Drupal);
