(function (Drupal) {
  Drupal.behaviors.backend = {
    attach: function (context, settings) {
      const inputFields = context.querySelectorAll(
        'input[name="settings[block_form][field_seeds_widget_types]"]'
      );
      const stateDivs = context.querySelectorAll("div[data-drupal-states]");

      if (inputFields.length > 0 && stateDivs.length > 0) {
        stateDivs.forEach((div) => (div.style.display = "none"));

        // Attach event listener to each input field
        inputFields.forEach((input) =>
          input.addEventListener("change", checkAndToggleDivs)
        );

        function checkAndToggleDivs(event) {
          const inputValue = event.target.value; // Get the value of the triggered input

          stateDivs.forEach((div) => {
            const states = JSON.parse(
              div.getAttribute("data-drupal-states").replace(/&quot;/g, '"')
            );
            const targetValue =
              states.visible &&
              states.visible[':input[name="field_seeds_widget_types"]']
                ? states.visible[':input[name="field_seeds_widget_types"]']
                    .value
                : "";

            // Show the div only if its target value matches the triggered input's value
            if (inputValue === targetValue) {
              div.style.display = "block";
            } else {
              div.style.display = "none";
            }
          });
        }
      }
    },
  };
})(Drupal);
