const chokidar = require("chokidar");
const { exec } = require("child_process");
const path = require("path");

// Array of file pairs to watch and compile
const filesToWatch = [
  {
    inputFile: "./assets/style/backend.pcss.css",
    outputFile: "./assets/css/backend.css",
  },
  // Add more file pairs as needed
];

// PostCSS CLI command
const postcssCommand = (inputFile, outputFile) =>
  `npx postcss ${inputFile} -o ${outputFile}`;

function compile(filePath) {
  const normalizedFilePath = path.normalize(filePath);
  const filePair = filesToWatch.find(
    ({ inputFile }) => path.normalize(inputFile) === normalizedFilePath
  );

  if (!filePair) {
    console.error(`No output file specified for ${normalizedFilePath}`);
    return;
  }

  exec(
    postcssCommand(filePair.inputFile, filePair.outputFile),
    (err, stdout, stderr) => {
      if (err) {
        console.error(`Error compiling ${filePair.inputFile}:`, stderr);
      } else {
        console.log(`Compiled ${filePair.inputFile} to ${filePair.outputFile}`);
      }
    }
  );
}

function buildAll() {
  filesToWatch.forEach(({ inputFile, outputFile }) => {
    exec(postcssCommand(inputFile, outputFile), (err, stdout, stderr) => {
      if (err) {
        console.error(`Error compiling ${inputFile}:`, stderr);
      } else {
        console.log(`Compiled ${inputFile} to ${outputFile}`);
      }
    });
  });
}

function watchFiles() {
  filesToWatch.forEach(({ inputFile }) => {
    const watcher = chokidar.watch(inputFile, {
      ignored: /(^|[\/\\])\../, // ignore dotfiles
      persistent: true,
    });

    watcher
      .on("add", compile)
      .on("change", compile)
      .on("unlink", (path) => console.log(`File ${path} has been removed`));
  });

  console.log(`Watching for file changes...`);
}

// Determine whether to watch files or build all
const args = process.argv.slice(2);
if (args.includes("build")) {
  buildAll();
} else {
  watchFiles();
}
