# Seeds Widgets Module

## Overview

The **Seeds Widgets** module provides custom widgets for enhancing content display in Drupal. It integrates seamlessly with Drupal's block and field systems, offering a flexible way to add interactive elements to your site.

## Features

- Custom widgets for content fields.
- Integration with Drupal’s block system.
- Configurable options for widget behavior.
- Support for modern JavaScript frameworks.

## Requirements

- Drupal 10.x
- PHP 8.1 or higher

## Installation

1. Download the module and place it in the `modules/contrib/seeds_widgets` directory.
2. Enable the module via the **Extend** page (`/admin/modules`) or using Drush:
   ```sh
   drush en seeds_widgets -y
   ```
3. Clear the cache:
   ```sh
   drush cr
   ```

## Configuration

- Navigate to **Configuration** → **Seeds Widgets Settings** (`/admin/config/seeds_widgets`).
- Adjust widget settings as needed.
- Assign widgets to fields in the **Manage Display** section of content types.

## Development

### Running JavaScript Tools

This module includes JavaScript files that require Node.js.

1. Install dependencies:
   ```sh
   npm install
   ```
2. Compile assets:
   ```sh
   npm run build
   ```

## Contributing

Contributions are welcome! Please open an issue or submit a pull request via the project repository.

## License

This module is licensed under the GPL-2.0-or-later license.
