(function (Drupal) {
  Drupal.behaviors.tableSearch = {
    attach: function (context) {
      document
        .getElementById("tableSearch")
        .addEventListener("keyup", function () {
          let filter = this.value.toLowerCase();
          let selectedColumn = document.getElementById("columnSelect").value;
          let rows = document.querySelectorAll(".table tbody tr");

          rows.forEach((row) => {
            let cells = row.getElementsByTagName("td");
            let match = false;

            if (selectedColumn === "all") {
              // Search all columns
              for (let cell of cells) {
                if (cell.textContent.toLowerCase().includes(filter)) {
                  match = true;
                  break;
                }
              }
            } else {
              // Search specific column
              let cell = cells[parseInt(selectedColumn)];
              if (cell && cell.textContent.toLowerCase().includes(filter)) {
                match = true;
              }
            }

            row.style.display = match ? "" : "none";
          });
        });
    },
  };
})(Drupal);
