/* global Select */
((Drupal, once, Select) => {
  Drupal.behaviors.selectA11yNG = {
    attach(context) {
      once(
        'once-select-a11y-ng',
        'select.select-a11y-ng-widget',
        context,
      ).forEach((element) => {
        const configAttribute = element.getAttribute(
          'data-select-a11y-ng-config',
        );
        const config = JSON.parse(configAttribute);
        const placeholder = config.placeholder ?? Drupal.t('Search in list');
        const search = config.search ?? true;
        const options = {
          text: {
            help: Drupal.t(
              'Navigate the list to find what you are looking for',
            ),
            placeholder,
            noResult: Drupal.t('Nothing found'),
            results: Drupal.t('{x} suggestion(s) found'),
            deleteItem: Drupal.t('Remove {t}'),
            delete: Drupal.t('Remove'),
          },
          search,
        };
        /* eslint-disable no-new */
        new Select(element, options);
      });
    },
  };
})(Drupal, once, Select);
