<?php

namespace Drupal\select_a11y_ng_bef\Plugin\better_exposed_filters\filter;

use Drupal\Core\Form\FormStateInterface;
use Drupal\better_exposed_filters\Plugin\better_exposed_filters\filter\FilterWidgetBase;

/**
 * Select A11y widget implementation.
 *
 * @BetterExposedFiltersFilterWidget(
 *   id = "bef_select_a11y_ng",
 *   label = @Translation("Select A11y NG"),
 * )
 */
class SelectA11yNG extends FilterWidgetBase {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration(): array {
    $config = parent::defaultConfiguration();
    $config['advanced']['placeholder_text'] = (string) $this->t('- None -');
    $config['search'] = TRUE;
    return $config;
  }

  /**
   * {@inheritdoc}
   */
  public function exposedFormAlter(array &$form, FormStateInterface $form_state): void {

    $field_id = $this->getExposedFilterFieldId();

    parent::exposedFormAlter($form, $form_state);

    if (!empty($form[$field_id])) {
      $filter = $this->handler;

      $form[$field_id]['#type'] = 'select_a11y_ng';
      $form[$field_id]['#autocomplete'] = !empty($filter->options['type']) && $filter->options['type'] === 'textfield';
      $form[$field_id]['#multiple'] = $filter->options['expose']['multiple'] ?? FALSE;
      $form[$field_id]['#select_a11y_ng'] = [
        'placeholder' => $this->configuration['advanced']['placeholder_text'],
        'search' => (bool) $this->configuration['search'],
      ];
    }
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state): array {

    $form = parent::buildConfigurationForm($form, $form_state);

    $form['advanced']['placeholder_text'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Placeholder text'),
      '#required' => TRUE,
      '#description' => $this->t('Text to be shown in the Select A11y field until a value is selected.'),
      '#default_value' => $this->configuration['advanced']['placeholder_text'],
    ];

    $form['search'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable search'),
      '#description' => $this->t('Adds a search input field to enable filtering of values.'),
      '#default_value' => $this->configuration['search'],
    ];

    return $form;
  }

}
