/* global Select */
(($, Drupal, Select) => {
  Drupal.behaviors.selectA11yNGFacet = {
    attach(context, settings) {
      once(
        'facets-dropdown-select-a11y-ng',
        'select.js-facets-select-a11y-ng-widget',
        context,
      ).forEach((element) => {
        // Add change handler.
        $(element).on('change', (e) => {
          window.location = element.options[e.detail].value;
        });

        // Get id.
        const id = $(element).data('drupal-facet-id');

        /* eslint-disable no-new */
        new Select(element, {
          text: {
            help: Drupal.t(
              'Navigate the list to find what you are looking for',
            ),
            placeholder:
              settings.facets.dropdown_widget[id][
                'facet-default-option-label'
              ] || Drupal.t('Search in list'),
            noResult: Drupal.t('Nothing found'),
            results: Drupal.t('{x} suggestion(s) found'),
            deleteItem: Drupal.t('Remove {t}'),
            delete: Drupal.t('Remove'),
          },
        });
      });
    },
  };
})(jQuery, Drupal, Select);
