<?php

namespace Drupal\select_a11y_ng_bef\Plugin\better_exposed_filters\sort;

use Drupal\Core\Form\FormStateInterface;
use Drupal\better_exposed_filters\Plugin\better_exposed_filters\sort\SortWidgetBase;

/**
 * Select A11y sort widget implementation.
 *
 * @BetterExposedFiltersSortWidget(
 *   id = "bef_select_a11y_ng",
 *   label = @Translation("Select A11y NG"),
 * )
 */
class SelectA11yNG extends SortWidgetBase {

  /**
   * {@inheritdoc}
   */
  public function exposedFormAlter(array &$form, FormStateInterface $form_state): void {
    parent::exposedFormAlter($form, $form_state);

    foreach ($this->sortElements as $element) {
      if (!empty($form[$element])) {
        $form[$element]['#type'] = 'select_a11y_ng';
        $form[$element]['#select_a11y_ng'] = [
          'search' => FALSE,
        ];
      }
    }
  }

}
