# Select A11y NG for Webform

This module provides integration between the Select A11y NG module and the Webform module, allowing you to use the accessible Select A11y NG widget in your webforms.

## Requirements

- Drupal 10.3+ or 11+
- Webform module
- Select A11y NG module

## Installation

1. Enable the Select A11y NG module
2. Enable the Webform module
3. Enable the Select A11y NG for Webform module

## Usage

1. Create or edit a webform
2. Add a new element or edit an existing select element
3. Change the element type to "Select A11y NG"
4. Configure the element options:
   - **Allow search**: Enable/disable the search functionality
   - **Placeholder**: Set a placeholder text for the field

## Features

- Fully accessible select widget compliant with WCAG standards
- Search/filter functionality for large option lists
- Support for single and multiple selection
- Customizable placeholder
- Seamless integration with Webform's element configuration

## Configuration Options

The Select A11y NG element supports the following configuration options:

- **Multiple values**: Enable multiple selection
- **Options**: Define the available options
- **Default value**: Set a default selected value
- **Placeholder**: Text shown when no value is selected
- **Search**: Enable/disable search functionality

## Development

The module provides a WebformElement plugin that extends the base Select element from Webform and replaces the render element with select_a11y_ng.