<?php

namespace Drupal\selective_contextual_edit;


use Drupal\Core\Field\FormatterInterface;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Component\Utility\NestedArray;

class SCEHelper {

  public static function prepareConfigurationSettings($settings) {
    $defaultSettings = [
      'enabled' => FALSE,
      'form_mode' => 'default',
    ];
    return $settings = NestedArray::mergeDeep($defaultSettings, $settings);
  }

  public static function settingsForm(FormatterInterface $plugin, FieldDefinitionInterface $field_definition, $view_mode, $form, FormStateInterface $form_state) {
    $elements = [];

    $field_info = $field_definition->getFieldStorageDefinition();
    if (!empty($field_info)) {
      $field_name = $field_info->getName();
      $entity_type = $field_definition->getTargetEntityTypeId();
      $bundle = $field_definition->getTargetBundle();

      $settings = self::prepareConfigurationSettings($plugin->getThirdPartySettings('selective_contextual_edit'));
      $wrapper_options = ['div'];
      $wrapper_options = ['_default' => t('Default')] + array_combine($wrapper_options, $wrapper_options) + ['_other' => t('Other')];

      $elements['selective_contextual_edit'] = [
        '#type' => 'details',
        '#title' => t('Selective Contextual Edit Settings'),
        // Default to open if we have any values to show.
        '#open' => $settings['enabled'],
      ];

      $elements['selective_contextual_edit']['enabled'] = [
        '#type' => 'checkbox',
        '#title' => t('Enable'),
        '#default_value' => $settings['enabled'],
      ];

      $form_modes = \Drupal::service('entity_display.repository')
        ->getFormModeOptionsByBundle($entity_type, $bundle);

      $elements['selective_contextual_edit']['form_mode'] = [
        '#type' => 'select',
        '#title' => t('Form mode'),
        '#description' => t('Select form mode to use for the contextual edit form for rendering this field widget. This field needs to be enabled in the selcted form mode.'),
        '#options' => $form_modes,
        '#default_value' => $settings['form_mode'],
        '#states' => [
          'visible' => [
            ':input[name="fields[' . $field_name . '][settings_edit_form][third_party_settings][selective_contextual_edit][enabled]"]' => ['checked' => TRUE],
          ]
        ]
      ];
    }

    return $elements['selective_contextual_edit'];
  }


  public static function formatter_settings_summary_alter(array &$summary, array $context) {
    $formatter_plugin = $context['formatter'];
    $settings = self::prepareConfigurationSettings($formatter_plugin->getThirdPartySettings('selective_contextual_edit'));

    if ($settings['enabled']) {
      $summary[] = t('Selective Contextual Edit enabled');
    }
  }
}
