<?php

namespace Drupal\selective_contextual_edit\Controller;

use Drupal\Core\Access\AccessResult;
use Drupal\selective_contextual_edit\Form\SingleFieldEntityForm;
use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityInterface;

class Controller extends ControllerBase {
  public function singelFieldEdit(EntityInterface $entity, $field_name, $form_mode) {
    $form = \Drupal::formBuilder()->getForm(SingleFieldEntityForm::class, $entity, $field_name, $form_mode);
    return $form;
  }

  /**
   * Access check for the singel field edit form.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity to update
   * @param string $field_name
   *   The field_name to be updated
   * @return \Drupal\Core\Access\AccessResultInterface
   *   An access result
   *
   * @throws \Symfony\Component\HttpKernel\Exception\NotFoundHttpException
   */
  public function singelFieldEditAccess(EntityInterface $entity, $field_name) {
    /** @var ContentEntityInterface $entity */
    $access = $entity->get($field_name)->access('edit');
    // $access = $entity->access('update', NULL, TRUE)
    //   ->andIf();
    return AccessResult::allowedIf($access);
  }
}
