# SEO Analyzer

The SEO Analyzer module helps you improve the SEO of your Drupal content by
evaluating your node or canvas page's adherence to SEO best practices.
It allows you to input a keyword or keyphrase and see how well your content
performs for that specific keyword.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/seo_analyzer).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/seo_analyzer).

## Table of contents

- Requirements
- Installation
- Configuration
- Features
- Maintainers

## Requirements

This module requires no modules outside of Drupal core.

## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-
drupal/installing-drupal-modules).

## Configuration

After enabling the module, ensure that the access seo analyzer permission
is assigned to the necessary roles.
Then you will see a new task link 'SEO Analyzer' (just like the 'Edit'
or 'Translate' links for nodes and canvas pages).
You will see the results there and on top of the page you can enter a keyword
to check the content against for SEO.

## Features

- Checks meta titles and descriptions for keyword inclusion.
- Verifies keyword usage in headings (H1, H2).
- Analyzes keyword density and identifies overuse.
- Checks for secure connections (SSL/HTTPS).
- Ensures proper HTML heading structure and alt text for images.
- Evaluates URL length and presence of keywords.
- Offers suggestions for improving SEO based on best practices.

## Maintainers

Current maintainers:

- Joery Lemmens - [flyke](https://www.drupal.org/u/flyke)
