# SEO Urls

Sometimes when we use, for example, a view with filters on the
page (node, term, etc.), we can get a large URL path. But in some
cases we want the SEO data to have a better, more readable look for
certain sets of filters.

This module allows creating an alternative URL for some existing one
and use seo-url token in metatags.

For example: `node:seo-url`

In general, this token works as a default url token, but if it sees that
there is an alternative for the current URL, it will replace it with
the new one.


## Requirements

- Core Link module - to use a link field
- PHP version more than 8.1
- Recommended Drupal version 10.3
- Recommended [metatag](https://www.drupal.org/project/link) - to provide SEO Url via **[seo-url]** entity token

## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Configuration

The module configuration is in entity structure: **/admin/structure/seo_url**.
When enabled, the module will prevent the links from appearing. To get the links back, disable the module and clear caches.

## Usage

1. Enable the SEO URLs module.
2. Configure the SEO URLs:
   * Go to  **/admin/structure/seo_url**
   * Select the entity types where you want to use the SEO URLs
3. Create a new SEO URL:
   * Go to **/admin/content/seo_url**
   * Click on **Add SEO URL**
   * Fill in the form
   * Save
4. But the better way to create a new SEO URL from the current page:
   * Go to page that needs a SEO URL
   * Click on **Create SEO URL** link on the admin toolbar
   * Fill in the form
   * Save
5. Configure metatags:
   * Go to **/admin/config/search/metatag**
   * Add `[<entity_types>:seo-url] token to the canonical path

## Views

The module also provides a way to provide a SEO Url for view pages.
For that you need to enable the [seo_urls_views](modules/seo_urls_views/README.md) module.

