<?php

/**
 * @file
 * Install, update functions for the SEO URLs module.
 */

declare(strict_types=1);

use Drupal\Core\Render\BubbleableMetadata;
use Drupal\seo_urls\SeoUrlManagerInterface;

/**
 * Implements hook_token_info_alter().
 */
function seo_urls_views_token_info_alter(array &$info): void {
  $info['tokens']['view']['seo-url'] = [
    'name' => t('SEO URL'),
    'description' => t('The SEO URL of the views page.'),
  ];
}

/**
 * Implements hook_tokens().
 */
function seo_urls_views_tokens(string $type, array $tokens, array $data, array $options, BubbleableMetadata $bubbleable_metadata): array {
  $url_options = ['absolute' => TRUE];
  $replacements = [];

  if ($type == 'view' && !empty($data['view'])) {
    /** @var \Drupal\views\ViewExecutable $view */
    $view = $data['view'];

    foreach ($tokens as $name => $original) {
      if ($name != 'seo-url') {
        continue;
      }

      /** @var \Drupal\seo_urls\SeoUrlManagerInterface $seo_url_manager */
      $seo_url_manager = \Drupal::service(SeoUrlManagerInterface::class);
      if ($value = $seo_url_manager->getSeoUrlToken($view, $url_options)) {
        $replacements[$original] = $value;
      }
    }
  }

  return $replacements;
}
