<?php

/**
 * @file
 * Install, update functions for the SEO URLs module.
 */

declare(strict_types=1);

use Drupal\Core\Render\BubbleableMetadata;
use Drupal\seo_urls\SeoUrlManagerInterface;

/**
 * Implements hook_token_info().
 */
function seo_urls_token_info(): array {
  $info = [];

  /** @var \Drupal\seo_urls\SeoUrlManagerInterface $seo_url_manager */
  $seo_url_manager = \Drupal::service(SeoUrlManagerInterface::class);
  foreach ($seo_url_manager->getAllowedEntityTypes() as $entity_type) {
    $info['tokens'][$entity_type]['seo-url'] = [
      'name' => t('SEO URL'),
      'description' => t('The SEO URL of the @entity_type.', ['@entity_type' => $entity_type]),
      'needs-data' => $entity_type,
    ];
  }

  return $info;
}

/**
 * Implements hook_tokens().
 */
function seo_urls_tokens(string $type, array $tokens, array $data, array $options, BubbleableMetadata $bubbleable_metadata): array {
  $url_options = ['absolute' => TRUE];
  $replacements = [];

  /** @var \Drupal\seo_urls\SeoUrlManagerInterface $seo_url_manager */
  $seo_url_manager = \Drupal::service(SeoUrlManagerInterface::class);
  $allowed_entity_types = $seo_url_manager->getAllowedEntityTypes();

  if (in_array($type, $allowed_entity_types) && !empty($data[$type])) {
    /** @var \Drupal\Core\Entity\ContentEntityInterface $entity */
    $entity = $data[$type];

    foreach ($tokens as $name => $original) {
      if ($name != 'seo-url') {
        continue;
      }

      if ($value = $seo_url_manager->getSeoUrlToken($entity, $url_options)) {
        $replacements[$original] = $value;
        $bubbleable_metadata->addCacheableDependency($entity);
      }
    }
  }

  return $replacements;
}
