<?php

declare(strict_types=1);

namespace Drupal\seo_urls\Plugin\Validation\Constraint;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Validation\Attribute\Constraint;
use Symfony\Component\Validator\Constraint as BaseConstraint;

/**
 * Checks if an entity field has a unique value.
 */
#[Constraint(
  id: 'UniqueLink',
  label: new TranslatableMarkup('Unique link constraint', [], ['context' => 'Validation'])
)]
class UniqueLinkConstraint extends BaseConstraint {

  /**
   * Error message.
   *
   * @var string
   */
  public string $message = 'A @entity_type with @field_name %value already exists.';

  /**
   * {@inheritdoc}
   */
  public function validatedBy(): string {
    return '\Drupal\seo_urls\Plugin\Validation\Constraint\UniqueLinkValueValidator';
  }

}
