<?php

namespace Drupal\session_management;

use Drupal\Core\Form\FormStateInterface;

class Utilities
{

  public static function addSupportButton(array &$form, FormStateInterface $form_state)
  {
    $base_url = \Drupal::request()->getSchemeAndHttpHost().\Drupal::request()->getBasePath();
    $module_path = \Drupal::service('extension.list.module')->getPath('session_management');
    $support_image_url = $base_url . '/' . $module_path . '/includes/images/mo-customer-support.png';
    $form['mo_ldap_auth_customer_support_icon'] = [
      '#markup' => t('<a class="use-ajax mo-bottom-corner" data-dialog-options="{&quot;width&quot;:&quot;55%&quot;}"
data-dialog-type="modal" href="support"><img src="' . $support_image_url . '" alt="support image"></a>'),
    ];
  }
}
