<?php

namespace Drupal\sgd_dashboard\Plugin\SgdCompanion;

use Drupal\sgd_dashboard\SgdCompanionPluginBase;

/**
 * Provides a SGD Companion plugin.
 *
 * @SgdCompanion(
 *   id = "sgd_companion_memory_profiler_plus",
 * )
 */
class SgdCompanionMemoryProfilerPlus extends SgdCompanionPluginBase {

  /**
   * {@inheritdoc}
   */
  public function canProcessStatus($statusData) : bool {

    // If the module 'Memory profiler plus' is installed on the site we may
    // have data from it.
    // Just checking for the existance of 'memory_profiler_plus' is enough.
    if (array_key_exists('memory_profiler_plus', $statusData)) {
      return TRUE;
    }
    else {
      return FALSE;
    }
  }

  /**
   * {@inheritdoc}
   */
  public function saveStatus($websiteData, $statusData, $enabledProjects = NULL) : bool {

    if ($this->canProcessStatus($statusData)) {

      $data = $statusData['memory_profiler_plus'];

      $websiteData->set('data_php_memory_usage', serialize($data));

    }
    else {
      $websiteData->set('data_php_memory_usage', NULL);
    }

    return TRUE;
  }

  /**
   * {@inheritdoc}
   */
  public function getStatusDefaults() : array {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public function getStatus($websiteData) : array | NULL {

    if ($dataSerialized = $websiteData->get('data_php_memory_usage')->value) {
      $data = unserialize($dataSerialized, ['allowed_classes' => FALSE]);
    }
    else {
      $data = NULL;
    }

    return $data;
  }

  /**
   * {@inheritdoc}
   */
  public function getBuildElements($websiteData) : array | NULL {

    if ($data = $this->getStatus($websiteData)) {
      return $data;
    }

    return NULL;
  }

}
