<?php

namespace Drupal\sgd_dashboard;

use Drupal\Component\Plugin\PluginBase;
use Drupal\Core\Datetime\DateFormatterInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides an abstract class for Site Guardian Companion plugins.
 */
abstract class SgdCompanionPluginBase extends PluginBase implements SgdCompanionPluginInterface {

  use StringTranslationTrait;

  /**
   * The date formatter interface.
   *
   * @var \Drupal\Core\Datetime\DateFormatterInterface
   */
  protected $dateFormatter;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('date.formatter'),
    );
  }

  public function __construct(array $configuration, $plugin_id, $plugin_definition, DateFormatterInterface $dateFormatter) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->dateFormatter = $dateFormatter;
  }

  /**
   * {@inheritdoc}
   */
  public function getName() {
    return $this->pluginDefinition['name'];
  }

  /**
   * {@inheritdoc}
   */
  public function getCreateFunction() {
    return [$this, 'createComponent'];
  }

  /**
   * Get a value attribute from a field or return default if not found.
   */
  protected function getValueOrDefault($field, $default = '-') {
    return isset($field) ? $field['value'] : $default;
  }

}
