<?php

namespace Drupal\sgd_dashboard;

use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Component\Plugin\PluginInspectionInterface;

/**
 * Provides an interface for static SgdCompanion plugins.
 */
interface SgdCompanionPluginInterface extends PluginInspectionInterface, ContainerFactoryPluginInterface {

  /**
   * Indicates whether the plugin can process the status data.
   *
   * Returns a boolean inidcating whether or not the status data array has any
   * data in it the companion plugin can process.
   */
  public function canProcessStatus($statusData) : bool;

  /**
   * Saves status data that plugin can process.
   *
   * Saves data that the companion plugin can handle from the status data
   * array to the appropriate location. Normally this would be the website
   * data entity referenced by the website node but could be elsewhere.
   * The plugin can also derive data from the status data (or elsewhere)
   * and store it as required.
   */
  public function saveStatus($websiteData, $statusData) : bool;

  /**
   * Returns titles and default values for elements of the status array.
   *
   * Each plugin only returns values for the data in the status data array
   * that the plugin handles.
   *
   * We need this as its possible the companion plugin will be asked for
   * data before it has actually recieved any from the target website.
   */
  public function getStatusDefaults() : array;

  /**
   * Retrieve the status informaton this plugin understands from the status.
   */
  public function getStatus($statusData) : array | NULL;

  /**
   * Returns an array of elements that can be used in a render/build array.
   */
  public function getBuildElements($websiteData) : array | NULL;

}
