<?php

namespace Drupal\sgd_dashboard;

use Drupal\views\EntityViewsData;

/**
 * Provides views integration for enabled projects entities.
 */
class SgdEnabledProjectEntityViewsData extends EntityViewsData {

  /**
   * {@inheritdoc}
   */
  public function getViewsData() {

    $data = parent::getViewsData();

    $data['sgd_enabled_project']['table']['group'] = $this->t('Enabled project');

    $data['sgd_enabled_project']['website'] = [
      'title' => $this->t('Enabled project'),
      'help' => $this->t('Relate enabled project to the website node content'),
      'relationship' => [
        'base' => 'node_field_data',
        'base field' => 'nid',
        'id' => 'standard',
        'label' => $this->t('Related website node'),
      ],
    ];

    return $data;
  }

}
