<?php

namespace Drupal\sgd_dashboard;

use Drupal\views\EntityViewsData;

/**
 * Provides views integration for website data entities.
 */
class SgdWebsiteDataEntityViewsData extends EntityViewsData {

  /**
   * {@inheritdoc}
   */
  public function getViewsData() {

    $data = parent::getViewsData();

    $data['sgd_website_data']['table']['group'] = $this->t('Website Data');

    $data['sgd_website_data']['id'] = [
      'title' => $this->t('Website data'),
      'help' => $this->t('Relate website data to the website node content.'),
      'relationship' => [
        'base' => 'node__field_sgd_website_data',
        'base field' => 'target_id',
        'id' => 'standard',
        'label' => $this->t('Related website node'),
      ],
    ];

    return $data;
  }

}
