<?php

namespace Drupal\sgd_dashboard\Controller\SgdCompanion;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\sgd_dashboard\Entity\Bundle\WebsiteBundle;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides route responses for the User data page.
 */
class SgdUserDataController extends ControllerBase {

  /**
   * The SGD data service.
   *
   * @var \Drupal\sgd_dashboard\Services\SiteGuardianDataService
   */
  protected $dataService;

  /**
   * The Site Guardian Dashboard Companion plugin manager.
   *
   * @var \Drupal\sdg_dashboard\SgdCompanionPluginManager
   */
  protected $pluginManager;

  /**
   * {@inheritDoc}
   */
  public static function create(ContainerInterface $container) {

    $instance = parent::create($container);

    $instance->dataService = $container->get('siteguardian.DataService');
    $instance->pluginManager = $container->get('plugin.manager.sgd_companion');

    return $instance;
  }

  /**
   * Display the User data for the website.
   *
   * @return array
   *   A render array as expected by
   *   \Drupal\Core\Render\RendererInterface::render().
   */
  public function view(WebsiteBundle $node, RouteMatchInterface $route_match) {

    // Get the php companion plugin.
    $plugin = $this->pluginManager->createInstance('sgd_companion_user_status', []);

    /** @var \Drupal\sgd_dashboard\Entity\SgdWebsiteData $websiteData */
    $websiteData = $node->getDataEntity();

    if ($elements = $plugin->getBuildElements($websiteData)) {
      $build = [
        '#theme' => 'sgd_user_data',
        '#data' => $elements,
      ];
    }
    else {
      $build = [
        '#markup' => '<p>' . $this->t("No user data available. Check the 'Site Guardian API User Data' companion module is installed and enabled on the target website.") . '</p>',
      ];
    }

    $build['#attached']['library'][] = 'sgd_dashboard/sgd_user_data';

    return $build;
  }

}
