<?php

namespace Drupal\sgd_dashboard\Services;

/**
 * Interface for the End of Life Client Service.
 */
interface EndOfLifeClientServiceInterface {

  /**
   * Gets the End of Life data for a single cycle of a product.
   *
   * @param string $product
   *   The product name.
   * @param string $cycle
   *   The product cycle.
   *
   * @return array|bool
   *   An array containing cycle information, or FALSE if not found.
   *
   * @throws \Drupal\sgd_dashboard\Exception\EndOfLifeClientException
   *   Thrown when there's an error accessing the API.
   */
  public function getSingleCycle($product, $cycle): array|bool;

}
