<?php

namespace Drupal\sgd_dashboard;

use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;

/**
 * Class for Sgd Companion plugin manager.
 *
 * @ingroup plugin_api
 */
class SgdCompanionPluginManager extends DefaultPluginManager {

  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {

    parent::__construct(
      'Plugin/SgdCompanion',
      $namespaces,
      $module_handler,
      'Drupal\sgd_dashboard\SgdCompanionPluginInterface',
      'Drupal\Component\Annotation\Plugin',
      ['Drupal\sgd_dashboard\Annotation']
    );

    $this->alterInfo('sgd_companion_info');
    $this->setCacheBackend($cache_backend, 'sgd_companion_plugins');
  }

}
