<?php

namespace Drupal\sgd_dashboard\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\Routing\TrustedRedirectResponse;
use Drupal\sgd_dashboard\Entity\Bundle\WebsiteBundle;
use Symfony\Component\HttpFoundation\RedirectResponse;

/**
 * Provides redirect responses for the Visit website route.
 */
class SgdWebsiteVisitController extends ControllerBase {

  /**
   * Redirect to the actual external website.
   */
  public function visit(WebsiteBundle $node, RouteMatchInterface $route_match): RedirectResponse {

    $url = $node->getBaseUrl();

    return new TrustedRedirectResponse($url);
  }

}
