<?php

namespace Drupal\sgd_dashboard\Plugin\SgdCompanion;

use Drupal\sgd_dashboard\SgdCompanionPluginBase;

/**
 * Provides a SGD Companion plugin.
 *
 * @SgdCompanion(
 *   id = "sgd_companion_server_benchmarks",
 * )
 */
class SgdCompanionServerBenchmarks extends SgdCompanionPluginBase {

  /**
   * {@inheritdoc}
   */
  public function canProcessStatus($statusData) : bool {

    // If the Site Guardian API Companion module 'User status' is installed on
    // the site we should have data from it.
    // Just checking for the existance of 'sgd_server_benchmarks' is enough.
    if (array_key_exists('sgd_server_benchmarks', $statusData)) {
      return TRUE;
    }
    else {
      return FALSE;
    }
  }

  /**
   * {@inheritdoc}
   */
  public function saveStatus($websiteData, $statusData, $enabledProjects = NULL) : bool {

    if ($this->canProcessStatus($statusData)) {

      $benchmarkData = [
        'sgd_server_benchmarks' => $statusData['sgd_server_benchmarks'],
      ];

      $websiteData->set('data_server_benchmarks', serialize($benchmarkData));

    }
    else {
      $websiteData->set('data_server_benchmarks', NULL);
    }

    return TRUE;
  }

  /**
   * {@inheritdoc}
   */
  public function getStatusDefaults() : array {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public function getStatus($websiteData) : array | NULL {

    if ($dataSerialized = $websiteData->get('data_server_benchmarks')->value) {

      $data = unserialize($dataSerialized, ['allowed_classes' => FALSE]);

    }
    else {
      $data = NULL;
    }

    return $data;
  }

  /**
   * {@inheritdoc}
   */
  public function getBuildElements($websiteData) : array | NULL {

    if ($data = $this->getStatus($websiteData)) {

      if (!empty($data['sgd_server_benchmarks'])) {

        $elements['iterations'] = $data['sgd_server_benchmarks']['settings']['iterations'];
        $elements['timestamp'] = $data['sgd_server_benchmarks']['settings']['timestamp'];

        foreach ($data['sgd_server_benchmarks']['php'] as $key => $value) {
          $elements['php'][$key] = $value;
        }

        if (!empty($data['sgd_server_benchmarks']['db'])) {
          foreach ($data['sgd_server_benchmarks']['db'] as $key => $value) {
            $elements['db'][$key] = $value;
          }
        }

        foreach ($data['sgd_server_benchmarks']['io'] as $key => $value) {
          $elements['io'][$key] = $value;
        }

        return $elements;
      }

    }

    return NULL;
  }

}
