<?php

namespace Drupal\sgd_dashboard\Controller\SgdCompanion;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\sgd_dashboard\Entity\Bundle\WebsiteBundle;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides route responses for the PHP data page.
 */
class SgdPHPDataController extends ControllerBase {

  /**
   * The SGD data service.
   *
   * @var \Drupal\sgd_dashboard\Services\SiteGuardianDataService
   */
  protected $dataService;

  /**
   * The Site Guardian Dashboard Companion plugin manager.
   *
   * @var \Drupal\sdg_dashboard\SgdCompanionPluginManager
   */
  protected $pluginManager;

  /**
   * {@inheritDoc}
   */
  public static function create(ContainerInterface $container) {

    $instance = parent::create($container);

    $instance->dataService = $container->get('siteguardian.DataService');
    $instance->pluginManager = $container->get('plugin.manager.sgd_companion');

    return $instance;
  }

  /**
   * Display the PHP data for the website.
   *
   * @return array
   *   A render array as expected by
   *   \Drupal\Core\Render\RendererInterface::render().
   */
  public function view(WebsiteBundle $node, RouteMatchInterface $route_match) {

    // Get the php and memory profiler plus companion plugins.
    $pluginStatus = $this->pluginManager->createInstance('sgd_companion_php_status', []);
    $pluginMemory = $this->pluginManager->createInstance('sgd_companion_memory_profiler_plus', []);

    /** @var \Drupal\sgd_dashboard\Entity\SgdWebsiteData $websiteData */
    $websiteData = $node->getDataEntity();

    $build = [
      '#theme' => 'sgd_php_data',
    ];

    // Add the PHP status companion module data.
    if ($data = $pluginStatus->getStatus($websiteData)) {
      $build['#data']['status'] = $data;
    }

    // Add the PHP memory profiler plus module data.
    if ($data = $pluginMemory->getStatus($websiteData)) {
      $build['#data']['memory_usage'] = $data;
    }

    if (empty($build['#data'])) {
      $build = [
        '#markup' => '<p>' . $this->t("No PHP data available. Check the 'Site Guardian API PHP Data' companion module is installed and enabled on the target website.") . '</p>',
      ];
    }

    $build['#cache'] = ['max-age' => 0];

    $build['#attached']['library'][] = 'sgd_dashboard/sgd_php_data';

    return $build;
  }

}
