<?php

namespace Drupal\sgd_dashboard\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\views\Views;

use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides route responses for the Websites page.
 */
class SgdWebsitesController extends ControllerBase {

  /**
   * The SGD data service.
   *
   * @var \Drupal\sgd_dashboard\Services\SiteGuardianDataService
   */
  protected $dataService;

  /**
   * {@inheritDoc}
   */
  public static function create(ContainerInterface $container) {

    $instance = parent::create($container);

    $instance->dataService = $container->get('siteguardian.DataService');

    return $instance;
  }

  /**
   * Display the PHP data for the website.
   *
   * @return array
   *   A render array as expected by
   *   \Drupal\Core\Render\RendererInterface::render().
   */
  public function view(RouteMatchInterface $route_match) {

    // First build the "project by name" exposed filter.
    // This is from the websites projects view.
    $view = Views::getView('website_projects');

    $view->setDisplay('projects_by_name');

    $view->initHandlers();

    /** @var \Drupal\views\Plugin\views\exposed_form\ExposedFormPluginInterface $exposedForm */
    $exposedForm = $view->display_handler->getPlugin('exposed_form');

    $build['exposed_form'] = $exposedForm->renderExposedForm(TRUE);

    // Now the website list.
    $build['websites_list'] = [
      '#title' => 'Websites',
      'view' => [
        '#type' => 'view',
        '#name' => 'websites',
        '#display_id' => 'websites_block',
        '#embed' => TRUE,
      ],
    ];

    $build['#attached']['library'][] = 'sgd_dashboard/sgd_views';

    return $build;
  }

}
