<?php

namespace Drupal\sgd_dashboard\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\views\Views;

use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides route responses for the projects page.
 */
class SgdProjectsController extends ControllerBase {

  /**
   * The SGD data service.
   *
   * @var \Drupal\sgd_dashboard\Services\SiteGuardianDataService
   */
  protected $dataService;

  /**
   * {@inheritDoc}
   */
  public static function create(ContainerInterface $container) {

    $instance = parent::create($container);

    $instance->dataService = $container->get('siteguardian.DataService');

    return $instance;
  }

  /**
   * Display the view with the list of projects.
   *
   * @return array
   *   A render array as expected by
   *   \Drupal\Core\Render\RendererInterface::render().
   */
  public function view(RouteMatchInterface $route_match) {

    // First build the "project by name" exposed filter.
    // This is from the websites projects view.
    $view = Views::getView('website_projects');

    $view->setDisplay('projects_by_name');

    $view->initHandlers();

    /** @var \Drupal\views\Plugin\views\exposed_form\ExposedFormPluginInterface $exposedForm */
    $exposedForm = $view->display_handler->getPlugin('exposed_form');

    $build['exposed_form'] = $exposedForm->renderExposedForm(TRUE);

    // The projects list view.
    $build['websites_list'] = [
      '#title' => 'Projects by name',
      'view' => [
        '#type' => 'view',
        '#name' => 'website_projects',
        '#display_id' => 'projects_by_name',
        '#embed' => TRUE,
      ],
    ];

    $build['#attached']['library'][] = 'sgd_dashboard/sgd_views';

    return $build;
  }

}
