<?php

declare(strict_types=1);

namespace Drupal\sgd_dashboard;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;

/**
 * Provides a list controller for the enabled project entity entity type.
 */
final class SgdEnabledProjectEntityListBuilder extends EntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader(): array {

    $header['id'] = $this->t('ID');
    $header['name'] = $this->t('Name');
    $header['created'] = $this->t('Created');
    $header['changed'] = $this->t('Updated');

    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity): array {

    /** @var \Drupal\sgd_dashboard\SgdEnabledProjectEntityInterface $entity */
    $row['id'] = $entity->id();
    $row['name'] = $entity->get('name')->value;
    $row['created']['data'] = $entity->get('created')->view(['label' => 'hidden']);
    $row['changed']['data'] = $entity->get('changed')->view(['label' => 'hidden']);

    return $row + parent::buildRow($entity);
  }

}
