# Shareable Single Directory Components

Shareable Single Directory Components (SDC) allows developers to contribute and reuse SDCs across projects, without requiring them to be tied to a specific theme or module. This makes SDCs portable and sharable, reducing duplication and improving collaboration.

## Features

* Provides a way to create and share SDCs independently of a theme or module.
* Encourages reusability of component code across different projects.
* Reduces code duplication by letting you contribute SDCs from a single source.
* Makes it easier for teams to collaborate and contribute components back to the community.

## Use cases
* You want to share an SDC component across multiple projects without copying the code.
* You want to contribute reusable SDCs to the Drupal ecosystem.
* You want to maintain consistency across multiple sites by reusing the same SDCs.

## Post-Installation

After installing this module:

* Place your components under the <strong>components</strong> folder at the root level of the Drupal site
* Clear cache
* Embed or include your components as <code>{% include 'components:sdc'

## Single Directory Components Styleguide

Integrating with the [Single Directory Components Styleguide](https://www.drupal.org/project/sdc_styleguide module
should be a matter of just activating both modules and you should see the components in the components explorer at
`/explorer/styleguide` (keep in mind to check the module permissions).
